FILESEXTRAPATHS_prepend := "${THISDIR}/files:"

SRC_URI_append_dunfell = " \
           ${@bb.utils.contains('DISTRO_FEATURES', 'yocto-3.1.15', 'file://005_modify_CA_Bundle_path_3.1.15.patch', 'file://005_modify_CA_Bundle_path.patch', d)} \
                 "
SRC_URI_append_morty = " file://005_modify_CA_Bundle_path.patch"

SRC_URI_append_kirkstone = " file://005_modify_CA_Bundle_path_kirkstone.patch"

SRC_URI_append_class-target = " \
           file://usertrustrsaca2038.crt \
           file://USERTrustRSAAAACAxSign.crt \
           file://comodorsacertificationauthority.crt \
           file://LnF-ca-chain.pem \
           file://comodorsaorganizationvalidationsecureserverca.crt \
           file://comodorsaca2038.crt \
           file://SectigoRSADomainValidationSecureServerCA.crt \
           file://gsintranetsslsha256g3.crt \
           file://gsnonpublicroot2.crt \
           file://QuoVadis_Root_CA_2.crt \
           "
SRC_URI_append_class-nativesdk_dunfell += " \
            ${@bb.utils.contains('DISTRO_FEATURES', 'yocto-3.1.15', 'file://2021-esdk-cert-path-issue.patch', 'file://0001-esdk-cert-path-issue.patch', d)} \
                                  "
SRC_URI_append_class-nativesdk_kirkstone = " file://0001-esdk-cert-path-issue_kirkstone.patch"
SRC_URI_append_class-nativesdk_morty = " file://0001-esdk-cert-path-issue.patch"

DEPENDS += "openssl-native"

do_install_append_class-target() {

# Remove all NON-US Certs while keeping only few recommended one such as
# Baltimore_CyberTrust_Root.crt & Cybertrust_Global_Root.crt - comes under Digicert Trust Store
# GlobalSign certs used by SongId Card App for youtube images access
          install -d ${D}${datadir}/ca-certificates
          for i in `find ${D}${datadir}/ca-certificates/mozilla -type f -name '*.crt' -o -name '*.cert' -o -name '*.pem' \
            | grep -iv Comodo_\* | grep -iv GlobalSign_\* | grep -iv Baltimore_CyberTrust_Root.crt \
            | grep -iv Cybertrust_Global_Root.crt | grep -iv QuoVadis_Root_CA`;
          do
            subCrt=`/usr/bin/openssl x509 -in $i -noout -subject`
            if [ "x`echo "$subCrt" | grep "C=" | grep -v "C=US"`" != "x" ]; then
                rm -f $i
            fi
          done

# Few Certs from US should also be removed
# remove Equifax
          find ${D}${datadir}/ca-certificates -name ui_ca.pem | xargs rm -f

# Starfield removed to avoid subtlety, invasiveness, and potential privacy-breaching nature of 'Workspace Installer' tool
          find ${D}${datadir}/ca-certificates -type f -name '*.crt' -o -name '*.cert' -o -name '*.pem' | grep -i Starfield_* | xargs rm -f

# remove USERTrust to avoid fraudulent certificates that posed a dire risk to Internet security
          find ${D}${datadir}/ca-certificates -type f -name '*.crt' -o -name '*.cert' -o -name '*.pem' | grep -i USERTrust_* | xargs rm -f

# remove XRamp as it is owned by non trusted store
          find ${D}${datadir}/ca-certificates -type f -name '*.crt' -o -name '*.cert' -o -name '*.pem' | grep -i XRamp_* | xargs rm -f

# remove VISA certs, Ecommerce root should not be encountered
          find ${D}${datadir}/ca-certificates -type f -name '*.crt' -o -name '*.cert' -o -name '*.pem' | grep -i VISA_* | xargs rm -f

# remove untrusted cert TeliaSonera_Root_CA_v1.crt & UTN_USERFirst_Hardware_Root_CA.crt 
          find ${D}${datadir}/ca-certificates -type f -name TeliaSonera_Root_CA_v1.crt | xargs rm -f
          find ${D}${datadir}/ca-certificates -type f -name UTN_USERFirst_Hardware_Root_CA.crt | xargs rm -f
          find ${D}${datadir}/ca-certificates -type f -name UTN_USERFirst_Email_Root_CA.crt | xargs rm -f
          
# remove Lets'Encrypted CA certs, intermediate certs cross signed by IdenTrust store 
          find ${D}${datadir}/ca-certificates -type f -name '*.crt' -o -name '*.cert' -o -name '*.pem' | grep -i ISRG_* | xargs rm -f
          find ${D}${datadir}/ca-certificates -type f -name '*.crt' -o -name '*.cert' -o -name '*.pem' | grep -i IdenTrust_* | xargs rm -f

# remove cert blacklist and those certs orginate from a Mozilla blacklist
          #find ${D}${datadir}/ca-certificates -type f -name '*.crt' -o -name '*.cert' -o -name '*.pem' | grep -i DST_* | xargs rm -f
          find ${D}${datadir}/ca-certificates -name DST_ACES_CA_X6.crt | xargs rm -f 
# remove few more non trusted certs
          find ${D}${datadir}/ca-certificates -type f -name '*.crt' -o -name '*.cert' -o -name '*.pem' | grep -i Equifax_* | xargs rm -f
          find ${D}${datadir}/ca-certificates -type f -name WellsSecure_Public_Root_Certificate_Authority.crt | xargs rm -f
          
# install few trusted certs for TLS connection
	install -m 0644 ${WORKDIR}/comodorsacertificationauthority.crt ${D}${datadir}/ca-certificates
	install -m 0644 ${WORKDIR}/usertrustrsaca2038.crt ${D}${datadir}/ca-certificates/AddTrust_External_Root.crt
        install -m 0644 ${WORKDIR}/USERTrustRSAAAACAxSign.crt ${D}${datadir}/ca-certificates/USERTrustRSAAAACAxSign.crt
	install -m 0644 ${WORKDIR}/comodorsaca2038.crt ${D}${datadir}/ca-certificates
        install -m 0644 ${WORKDIR}/SectigoRSADomainValidationSecureServerCA.crt ${D}${datadir}/ca-certificates
	install -m 0644 ${WORKDIR}/comodorsaorganizationvalidationsecureserverca.crt ${D}${datadir}/ca-certificates
	install -m 0644 ${WORKDIR}/LnF-ca-chain.pem ${D}${datadir}/ca-certificates/LnF-ca-chain.crt

# install QuoVadis_Root_CA_2 cerificate
	install -m 0644 ${WORKDIR}/QuoVadis_Root_CA_2.crt ${D}${datadir}/ca-certificates
# install non public global signed certs
	install -m 0644 ${WORKDIR}/gsnonpublicroot2.crt ${D}${datadir}/ca-certificates
	install -m 0644 ${WORKDIR}/gsintranetsslsha256g3.crt ${D}${datadir}/ca-certificates
        # making an entry to config files
        echo "gsintranetsslsha256g3.crt" >> ${D}${sysconfdir}/ca-certificates.conf
        echo "gsnonpublicroot2.crt" >> ${D}${sysconfdir}/ca-certificates.conf

	install -d ${D}${sysconfdir}
	{
            echo "# Lines starting with # will be ignored"
            echo "# Lines starting with ! will remove certificate on next update"
            echo "#"
            find ${D}${datadir}/ca-certificates -type f -name '*.crt' |\
                sed 's,^${D}${datadir}/ca-certificates/,,'
        } >${D}${sysconfdir}/ca-certificates.conf

# Restructure Root CA Trust Store RDKALL-2429
# Replacing the Root CA Trust store from CPC repo
# Defaulting to RDK CA Store
        bbnote "Removing certs installed from debian ca store"
        rm -rf ${D}${datadir}/ca-certificates/mozilla
        rm -f ${D}${datadir}/ca-certificates/*.crt
        rm -f ${D}${sysconfdir}/ca-certificates.conf

}

FILES_${PN} += "${datadir}/ca-certificates/comcast/*"
FILES_${PN} += "${datadir}/ca-certificates/*.crt"
FILES_${PN} += "${datadir}/ca-certificates/*.pem"
